unit HKTEA;

interface

function TeaEncode(s:string) : string;
function TeaDecode(s:string) : string;


implementation

type
 tv = array[0..1] of integer;
 tk = array[0..3] of integer;

const key : array[1..512] of Integer = (
-1591724200,1196266282,1589705198,-1287852217,1064662445,-1426974979,1066834903,-425500864,
633547955,-1061415306,-1462177449,1944542281,-301648563,1102810124,49874905,1300079422,
-1653922602,-1836150522,-2048271626,1236891006,-43698959,-71380818,-1731031421,125680878,
94819870,82134307,-1698216426,1169141298,-578554143,2028598624,-2011580145,1669846338,
-1388866096,-1379556396,1738133368,1745010692,998935207,1156733509,867677854,-71725344,
1736079910,2135541568,-1439111035,1962474949,-19572212,422361388,1425192255,-634068326,
423610793,-1999061149,-1374807954,-510153174,-1604689217,-2051309332,770702412,1576542120,
-1806520823,-143281587,1529217973,-241777348,456012776,-993648032,-962308252,1412368844,
-1340786580,2144849420,751887383,-887785293,-1456037222,864787866,-827422969,-484732596,
-195188656,1091887843,-1958759217,-78573012,1789432844,696310938,-1492173887,-2116021952,
-1220881518,870059708,1815768927,432606739,-2139004183,-215036716,1488102131,-679981029,
812825230,-623197558,1410654074,235331984,-1202711778,-417422783,1419421523,749189569,
-848426332,1240511776,-208132732,951067925,402780603,402287450,1060461291,1256449838,
276424818,845284652,1970579399,1417478051,-637567710,-933845880,-2147015166,-1689696907,
-389920904,690403808,-1666229777,-552603357,-1597259018,1376443554,-1109008071,1885102063,
859442847,-1998142121,-1279471044,748040111,697954200,-1018988238,233772617,-270335369,
-984538169,-1855761981,693315826,-838810875,-1678630581,225396279,627929008,-1485183652,
146260179,-722975494,-537200943,-1393901397,1669471906,2029702174,-1579065762,862151390,
355103142,1419500184,606184353,-1861722558,800897131,-690546798,-649152801,590230023,
-175399582,1646855085,268592723,-985795269,13364275,550938246,2004660766,1021702538,
-454806224,-373614145,918251712,898266310,-748701088,1028856705,-1078430724,-1955481606,
1516351029,1150226321,-310913264,-159310320,1283002453,-1566459372,-1409749893,2082304946,
1133228279,-1025503790,-1425001181,2141342247,695034796,1200435049,297410707,707966788,
-1293627221,227622105,-1905493588,-1868975501,773344927,414132953,442522492,-1301088772,
1769191421,-540883107,-236302909,-1172584387,-723547107,-496092465,1463145997,-1722565999,
656156777,1113403447,1322928605,1549484209,143507903,-127339336,-2056406803,-1737356089,
-853052767,-1627027699,-1312232620,-557377885,1571158993,649057630,389630106,-1793521932,
744051845,254943727,-1650967747,-1120249451,-42189670,-1540354816,-943121626,-1585053685,
1982139706,-794509834,722724650,-1550335402,-1055515127,146741254,-1635672395,-103467630,
553112974,-1609828851,1835196036,845443370,-449576273,67647155,-1213224649,-1817300680,
187334897,-1100819977,417003395,-1977632904,-261376718,-949551270,-1895992304,341265230,
66853031,-1421828680,-263506749,-1157280788,-194382487,428028812,1570384680,-694841695,
1266766905,-223436428,326566489,1994142123,757557261,1288781034,-1529723497,1630098841,
616264268,-113296804,-1654066516,-1489789260,-644860933,-289667127,1433428926,-2041816161,
1820283005,851127074,-780630602,1788049384,1338303669,-230426342,1019725656,1109941867,
1488237044,1359702059,145237878,-1612931656,-1662091060,1147278734,1767254096,1906823849,
-1991475602,-1985312664,-691705147,-48268583,-1452890466,-140621631,-1559169807,228469716,
1720804107,-480974531,-1461243697,-644420702,1872466948,1452016724,224840400,222091496,
-1933482941,772463709,1583102172,-1322838877,276162188,311748315,-1430550241,1402262695,
-1334227736,355316825,-421200064,-1258318883,-1942817502,136592435,-2265135,1516549911,
518291941,-628475446,1345492134,1036941789,-819533593,1770552429,-317409973,-811799649,
316448109,-408521602,-23749557,650207207,1228419275,1649621975,-2086838607,2066492308,
-99154743,879795072,-1138359405,-330825912,-1904675801,597974029,-2129366198,447948729,
1581757155,-405331491,-1609926442,426135378,-1514942289,-2075353060,791691557,-957315891,
1572430245,622818269,-943338691,1625347975,-648042341,-1894649629,1608195441,370485475,
698353082,-1696404381,-821998533,-1352384535,-1640198288,1317837653,-714547028,1043291903,
378299803,-884324734,-370596606,-646058949,-207887503,1101070372,1163303781,229184251,
-2098353685,-336608884,-1932227855,1528598493,1854757892,1738462694,-2033038605,1487917017,
-448636205,-1982968944,-1078300071,31722500,-502138110,610361935,-1918574362,-1383108931,
-1630580270,672784487,993140808,2055872799,896632847,-900452975,-1272799402,797458498,
-177127781,673807131,-1027737194,-642627262,2030341400,1151590631,-127236690,-308856714,
2005447869,909747458,-1618101710,1053258372,-1210500342,-387248162,-755391855,830310545,
1822324752,-1544100890,1526888713,1165533763,-66009792,169145575,-29375960,1421210334,
1561301987,1962343134,-637512231,-627281158,663702824,1622013009,402411596,-208218070,
-1300717707,-1908273157,165459392,616989784,1167190414,782837899,-1411259981,653564526,
153475149,-58240996,1708529818,848054422,1723053819,-1436966411,-53592365,-1936134961,
1860964977,-467840514,-1863581217,1211982295,-840944687,-2059103413,1626983664,-470488287,
1034570257,982681849,9628787,169590601,-1510595163,-137566232,-638163374,977263629,
-861522854,-178608678,2091176801,1014276825,38495444,-76183022,639706072,-1273954553,
-2069643299,-251764941,-1570988895,-405215187,1104986203,1225841633,-1060480348,2081903184,
-705722732,-664898040,1486307026,-1351274848,24260182,1498622293,524849988,-394505987,
1629339782,-1005336332,1164401276,-154349526,-1272286107,-639153564,29143266,-12334547,
-2138612163,332931354,-550213173,1361243798,2103578688,928999743,333681031,356361306,
1706385410,-1255478298,-158969173,-812658166,391667895,162632304,-2115853456,533228450
);

procedure _TeaDecode(var v : Tv; k : TK);
const
 delta = $9e3779b9;
var
 y,z,sum,n : cardinal;
begin
 y:=v[0];
 z:=v[1];
 sum:=delta shl 5;
 for n:=1 to 32 do
 begin
  Dec(z,(y shl 4) + k[2] xor y + sum xor (y shr 5) + k[3]);
  Dec(y,(z shl 4) + k[0] xor z + sum xor (z shr 5) + k[1]);
  Dec(sum,delta);
 end;
 v[0]:=y;
 v[1]:=z;
end;

procedure _TeaEncode(var v : Tv; k : TK);
const
 delta = $9e3779b9;
var
 y,z,sum,n : Cardinal;
begin
 y:=v[0];
 z:=v[1];
 sum:=0;
 for n:=1 to 32 do
 begin
  Inc(sum,delta);
  inc(y,(z shl 4) + k[0] xor z + sum xor (z shr 5) + k[1]);
  inc(z,(y shl 4) + k[2] xor y + sum xor (y shr 5) + k[3]);
 end;
 v[0]:=y;
 v[1]:=z;
end;

function TeaEncode(s:string) : string;
var
 i,kp,bp:integer;
 v : tv;
 k : tk;
begin
 if Length(s)=0 then Exit;
 while Length(s) mod 8 <> 0 do s:=s+#10;
 setlength(Result,Length(s));
 kp:=1;
 bp:=1;
 for i:=1 to Length(s) div 8 do
 begin
  move(s[bp],v,8);
  move(key[kp],k,16);
  _teaencode(v,k);
  move(v,result[bp],8);
  Inc(bp,8);
  Inc(kp,4);
 end;
end;

function TeaDecode(s:string) : string;
var
 i,kp,bp:integer;
 v : tv;
 k : tk;
begin
 if Length(s)=0 then Exit;
 setlength(Result,Length(s));
 kp:=1;
 bp:=1;
 for i:=1 to Length(s) div 8 do
 begin
  move(s[bp],v,8);
  move(key[kp],k,16);
  _teadecode(v,k);
  move(v,result[bp],8);
  Inc(bp,8);
  Inc(kp,4);
 end;
end;


end.
void code(long* v, long* k)  {


implementation

end.

void decode(long* v,long* k)  {
 unsigned long n=32, sum, y=v[0], z=v[1],
 delta=0x9e3779b9 ;
sum=delta<<5 ;
                       /* start cycle */
while (n-->0) {
    z-= (y<<4)+k[2] ^ y+sum ^ (y>>5)+k[3] ; 
    y-= (z<<4)+k[0] ^ z+sum ^ (z>>5)+k[1] ;
   sum-=delta ;  }
                       /* end cycle */
v[0]=y ; v[1]=z ;  }

